/*------------------------------------------------------------------------------*
 * File Name: FileImport.h				 										*
 * Purpose: Declare functions defined n FileImport.c							*
 * Copyright (c)2003 OriginLab Corp.											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 07-28-2003 v7.0637 QA70-4911 IMPROVE_HDR_VAR_SCAN						*
 * EJP 09-24-2003 v7.5706 QA70-5230 NOTIFY_USER_OF_IMPORT_ERROR					*
 * Sim 06-26-2007 v8.0 KEEP_75_OC_CODE_WORK										*
 * Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE				*
 *------------------------------------------------------------------------------*/

#ifndef _FILEIMPORT_H
#define _FILEIMPORT_H

///---Sim 06-26-2007 v8.0 KEEP_75_OC_CODE_WORK
/*
#include <Tree.h>
#include <Page.h>
*/
#include <..\originlab\fu_utils.h>
///---END v8.0 KEEP_75_OC_CODE_WORK

///---Sim 06-26-2007 v8.0 KEEP_75_OC_CODE_WORK
/*
/// EJP 09-24-2003 v7.5706 QA70-5230 NOTIFY_USER_OF_IMPORT_ERROR
enum {
	IMPERR_NONE = 0,
	IMPERR_NO_FILTER,
	IMPERR_LOAD_FILTER,
	IMPERR_NO_TARGET_PAGE,
	IMPERR_GET_IMPORT_FUNC,
	IMPERR_IMPORT_FUNC_ERR,
	IMPERR_PREPARE_WKS,
	IMPERR_FILTER_TYPE,
	IMPERR_CANCEL_ON_LOCKED_COL,
};
/// end NOTIFY_USER_OF_IMPORT_ERROR
*/
///---END v8.0 KEEP_75_OC_CODE_WORK

/// EJP 10-30-2003 v7.5736 QA70-5448 NOTIFY_USER_OF_IMPORT_ERROR
//int ImportErrorMsgBox(int iErr, LPCSTR lpcszFilter=NULL);
/// end NOTIFY_USER_OF_IMPORT_ERROR
/*#
*/
int ImportFile(Page &pgTarget, LPCSTR lpcszFilter, LPCSTR lpcszFile, int nFile=0);

/*#
*/
int ImportFile(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile, int nFile=0);

/*#
*/
int ImportASCII(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile, int iFile=0);

/*#
*/
int ImportBinary(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile, int iFile=0);
///---Sim 06-26-2007 v8.0 KEEP_75_OC_CODE_WORK
/*
int PrepareWksColsForImport(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile);
*/
///---END v8.0 KEEP_75_OC_CODE_WORK

///---Sim 06-26-2007 v8.0 KEEP_75_OC_CODE_WORK
/*
bool BatchProcessing();
*/
///---END v8.0 KEEP_75_OC_CODE_WORK

/// EJP 07-28-2003 v7.0637 QA70-4911 IMPROVE_HDR_VAR_SCAN
/*#
*/
void get_ascii_file_header_variables(StringArray &saNames, StringArray &saValues, LPCSTR lpcszFile, TreeNode &trFilter);
/// end IMPROVE_HDR_VAR_SCAN

///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Import_file_(global_function)
*/
int import_file(LPCSTR strPageName, int nIndexLayer, LPCSTR lpcszDataFile, LPCSTR lpcszFilterName = NULL);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Import_files_(global_function)	
*/
int import_files(const StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilter = NULL);

// Last updated comment by Sim, 05-12-09
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Load_import_filter_(global_function)	

*/
int load_import_filter(LPCSTR lpcszFilterName, LPCSTR lpcszDataFile, LPCSTR lpcszPageName, int nLocation, TreeNode& trFilter);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Is_applicable_(global_function)
*/
bool is_applicable(TreeNode &trFilter, LPCSTR lpcszDataFile);
///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE

#endif // _FILEIMPORT_H
